**************************************************************************************
SAS code used to demonstrate how to use the SASphcpe.exe software in SAS;            *
SASphcpe.exe is used to compute Gonen and Heller Concordance probability.            *
Concordance probability and discriminatory power in proportional hazards regression  *
(Biometrika (2005), 92, 4, pp. 965-970;                                              *
**************************************************************************************

If you find any bugs, please contact Quincy Mo (moq@mskcc.org) at the 
Department of Epidemiology and Biostatistics
Memorial Sloan-Kettering Cancer Center, New York
**************************************************************************************

***************************** Attention ***************************************************
When use the software, the individuals with missing values should be removed!
*******************************************************************************************;

*Code used to prepare the input data file that is recognized by SASphcpe.exe;
data sampledata(drop= i r1 r2);
  do i=1 to 100;
    r1=rannor(0);r2=rannor(0);surv=exp(r1);dead=(r2>0);x1=rannor(0);x2=rannor(0);
    if i=2 then x2=.;output;
	output;
  end;
run;

proc phreg data=sampledata outest=est1 covout noprint;
  model surv*dead(0)=x1 x2;
  output out=q1 xbeta=xbeta;
run;

data parameter (keep= x1 x2);
set est1(where=(_type_='PARMS'));
run;

data varbeta(keep=x1 x2);
  set est1(where=(_type_='COV'));
run;

data design;
  set q1(keep=x1 x2);
  if nmiss(x1,x2)>0 then delete;
run;

*The estimated parameters, the covariance matrix and the design matrix
are needed for computing the Concordance probability;
data phcpedata;
set parameter varbeta design;
run;

*SASphcpe.exe can only correctly read tab or space delimited text file;
proc export data=phcpedata outfile="G:\SASphcpe\phcpedata.txt" 
	dbms=dlm replace; 
	delimiter = " ";
 * delimiter = '09'x;
run;

****************** Code demonstrating how to use SASphcpe.exe *****************;
*Suppose SASphcpe.exe and phcpedata.txt are in the folder G:\SASphcpe\;
*In the following code, the program will read phcpedata.txt, and output the result to
the file phcpeout.txt;

X "G:\SASphcpe\SASphcpe.exe G:\SASphcpe\phcpedata.txt G:\SASphcpe\phcpeout.txt";

********************* End of Demonstration ***************************************;

**************** Now read in the results *****************************************;
data phcpeResult;
infile "G:\SASphcpe\phcpeout.txt" dlm = '09'x firstobs=2;
input CPE StdErrorCPE;
run;

proc print data=phcpeResult; run;
