#############################
#
# July 28, 2014
#
# Iteratively reweighted least squares estimation of
# parameters in an additive model under the GJ link
#
# This function is called by the function "get.int.test" that tests for removable and non-removable interactions
# and by the function "get.bayes.est" that derives Bayes estimators of log odds
#
#############################

get.gj.beta.est <- function(n.val, m.val, x.mat, lambda = 0, beta.start=rep(0,ncol(x.mat)), tolerance=10e-7){

  epsilon <- 1000
  beta.old <- beta.start

  counter <- 0
  while(epsilon > tolerance & counter < 100){

    counter <- counter + 1
    eta.vector <- as.vector(x.mat %*% beta.old)
    if(lambda==0){
      p.lambda <- exp(eta.vector) / (1 + exp(eta.vector))
    }
    else{
      p.lambda <- (1 + lambda*eta.vector)^(1/lambda) / (1 + (1+lambda*eta.vector)^(1/lambda))
    }
    p.na.length <- length(which(is.na(p.lambda)))

    if(p.na.length > 0){
       beta.new <- rep(0, length(beta.old))
       epsilon <- tolerance * 0.10
       p.converge=F
    }
    else{
      p.converge=T
      error.vector <- (m.val/n.val)^(lambda) * (n.val - (n.val+m.val) * p.lambda)
      score.vector <- as.vector(t(x.mat) %*% error.vector)
  
      A.vec <- (m.val/n.val)^(2*lambda) * (n.val+m.val) * p.lambda * (1-p.lambda)
      A.mat <- diag(A.vec)
      info.mat <- t(x.mat) %*% A.mat %*% x.mat

      info.mat.det <- abs( det(info.mat) )
      if(is.na(info.mat.det)){
         info.mat.qr.rank <- ncol(info.mat) - 1
      }
      else{
        if(info.mat.det <= 0){
           info.mat.qr.rank <- ncol(info.mat) - 1
        }
        else{
          info.mat.qr.rank <- qr(info.mat)$rank
        }
      }
      if(info.mat.qr.rank < ncol(info.mat)){
        beta.new <- rep(0, length(beta.old))
        epsilon <- tolerance * 0.10
      }
      else{
        beta.new <- as.vector( beta.old ) + as.vector( solve(info.mat) %*% score.vector )
        epsilon <- sum ( abs(beta.new - beta.old) )
        beta.old <- beta.new
      }
    }

  }
  if(counter >= 100){
    p.converge=F
  }

  if(info.mat.qr.rank < ncol(info.mat)){
    beta.var <- diag(rep(100,length(beta.new)))
    beta.sd <- sqrt(diag(beta.var))
    beta.test <- rep(0, length(beta.new))
    beta.p <- rep(1, length(beta.new))

  }
  else{
    beta.var <- solve(info.mat)
    beta.sd <- sqrt(diag(beta.var))
    beta.test <- beta.new / beta.sd
    beta.p <- 2*(1-pnorm(abs(beta.test)))
  }

  obs.or <- n.val/m.val
  est.fit <- as.vector(x.mat %*% beta.new)
  if(lambda == 0){
    est.or <- exp(est.fit)
  }
  else{
    est.or <- (1 + lambda*est.fit)^(1/lambda)
  }
  log.likeli <- sum( n.val * log(p.lambda) + m.val * log(1 - p.lambda) )
  resid.ss <- sum( (obs.or - est.or)^2 )

  deriv.term <- (1 + lambda*est.fit)^(1/lambda) / lambda * ( est.fit/(1+lambda*est.fit) - 
                                                             1/lambda * log(1 + lambda*est.fit) )

#  i.b.b <- t(x.mat) %*% A.mat %*% x.mat
#  temp.i.b.l <- (n.val+m.val) * p.lambda*(1-p.lambda) * 1/(1+lambda*est.fit) * deriv.term
#  i.b.l <- t(x.mat) %*% temp.i.b.l 
#  i.l.l <- sum( (n.val+m.val) * p.lambda * (1-p.lambda) * deriv.term^2 ) 
#
#  info.matrix.top <- cbind( i.b.b, as.vector(i.b.l) )
#  info.matrix.bot <- c(as.vector(i.b.l), i.l.l)
#  info.matrix <- rbind(info.matrix.top, info.matrix.bot)
#  var.mat <- solve(info.matrix)

  ###############
  # variance of the estimated odds ratios
  ###############

#  deriv.f.beta <- x.mat / (1 + lambda * est.fit)
#  deriv.f.lambda <- 1/lambda * ( est.fit/(1+lambda*est.fit) - 1/lambda * log(1+lambda*est.fit) )
#  
#  deriv.mat <- cbind(deriv.f.beta, as.vector(deriv.f.lambda))
#  var.log.est.or <- deriv.mat %*% var.mat %*% t(deriv.mat)

  deriv.f.beta <- x.mat * (m.val/n.val)^(lambda)
  if(info.mat.qr.rank < ncol(info.mat)){
    var.log.est.or <- diag(rep(100, length(m.val)))
    converge=F
  }
  else{
    var.log.est.or <- deriv.f.beta %*% solve(t(x.mat) %*% A.mat %*% x.mat) %*% t(deriv.f.beta)
    converge=T
  }

  if(!p.converge){
    converge=F
  }
  result <- list(beta.est=beta.new, beta.sd=beta.sd, beta.p=beta.p, beta.test=beta.test, beta.var=beta.var, 
                 log.likeli=log.likeli, est.or=est.or, resid.ss=resid.ss, p.lambda = p.lambda, est.fit=est.fit,
                 var.est.or=var.log.est.or, converge=converge)

  return(result)

}

