###################################
#
# July 28, 2014
#
# This file explains how to run the codes - especially how to 
# get the results given in Tables 1, 2, and 3 of the paper
#
###################################


source("gj-beta-estimate.r")
source("interaction-test.r")
source("bayes-estimation.r")

###########
# 
# organize the Setiawan et al data in Table 1 for analysis
#
###########

########## begin organizing data ###########

case.data <- c(143,1004,78,874,72,881)
control.data <- c(328,2475,175,1456,101,758)

y1 <- case.data
y0 <- control.data

x <- c(rep(0,y1[1]),rep(1,y1[2]),rep(0,y1[3]),rep(1,y1[4]),rep(0,y1[5]),rep(1,y1[6]),
       rep(0,y0[1]),rep(1,y0[2]),rep(0,y0[3]),rep(1,y0[4]),rep(0,y0[5]),rep(1,y0[6]))
z <- c(rep(0,y1[1]),rep(0,y1[2]),rep(1,y1[3]),rep(1,y1[4]),rep(2,y1[5]),rep(2,y1[6]),
       rep(0,y0[1]),rep(0,y0[2]),rep(1,y0[3]),rep(1,y0[4]),rep(2,y0[5]),rep(2,y0[6]))

y <- c(rep(1,sum(case.data)), rep(0, sum(control.data)))

######### end organizing data ##########


setiawan.result <- get.int.test(y, x, z)   #### test for removable & non-removable interactions
setiawan.bayes <- get.bayes.est(y, x, z)   #### bayes estimation

print("SETIAWAN RESULTS")
print(setiawan.result)                  ### test statistics and p-values for removable ###
                                        ### and non-removable interactions ###
print(setiawan.bayes$log.odds.est)   ### estimated log odds ###
print(setiawan.bayes$log.odds.std.err)  ### standard errors ###
print(setiawan.bayes$rmse)              ### root mean squared errors)


###########
# 
# organize the Shoff & Newcomb data in Table 2 for analysis
#
###########

########## begin organizing data ###########

case.data <- c(20,16,51,373,85,178)
control.data <- c(81,31,31,1633,262,253)

y1 <- case.data
y0 <- control.data

x <- c(rep(0,y1[1]),rep(1,y1[2]),rep(2,y1[3]),rep(0,y1[4]),rep(1,y1[5]),rep(2,y1[6]),
       rep(0,y0[1]),rep(1,y0[2]),rep(2,y0[3]),rep(0,y0[4]),rep(1,y0[5]),rep(2,y0[6]))
z <- c(rep(1,y1[1]),rep(1,y1[2]),rep(1,y1[3]),rep(0,y1[4]),rep(0,y1[5]),rep(0,y1[6]),
       rep(1,y0[1]),rep(1,y0[2]),rep(1,y0[3]),rep(0,y0[4]),rep(0,y0[5]),rep(0,y0[6]))

y <- c(rep(1,sum(case.data)), rep(0, sum(control.data)))

######### end organizing data ##########

#################
#
# test for removable interaction
#
#################

shoff.result <- get.int.test(y, x, z)   #### test for removable & non-removable interactions
shoff.bayes <- get.bayes.est(y, x, z)   #### bayes estimation

print("SHOFF RESULTS")
print(shoff.result)                  ### test statistics and p-values for removable ###
                                     ### and non-removable interactions ###
print(shoff.bayes$log.odds.est)   ### estimated log odds ###
print(shoff.bayes$log.odds.std.err)  ### standard errors ###
print(shoff.bayes$rmse)              ### root mean squared errors)

###########
# 
# organize the Xu et al tea data in Table 3 for analysis
#
###########

########## begin organizing data ###########

case.data <- c(211, 117, 382, 148, 126, 45)
control.data <- c(226, 90, 322, 171, 153, 65)

y1 <- case.data
y0 <- control.data

x <- c(rep(0,y1[1]),rep(1,y1[2]),rep(0,y1[3]),rep(1,y1[4]),rep(0,y1[5]),rep(1,y1[6]),
       rep(0,y0[1]),rep(1,y0[2]),rep(0,y0[3]),rep(1,y0[4]),rep(0,y0[5]),rep(1,y0[6]))
z <- c(rep(0,y1[1]),rep(0,y1[2]),rep(1,y1[3]),rep(1,y1[4]),rep(2,y1[5]),rep(2,y1[6]),
       rep(0,y0[1]),rep(0,y0[2]),rep(1,y0[3]),rep(1,y0[4]),rep(2,y0[5]),rep(2,y0[6]))

y <- c(rep(1,sum(case.data)), rep(0, sum(control.data)))

#################
#
# test for removable interaction
#
#################

xu.result <- get.int.test(y, x, z)   #### test for removable & non-removable interactions
xu.bayes <- get.bayes.est(y, x, z)   #### bayes estimation

print("XU RESULTS")
print(xu.result)                  ### test statistics and p-values for removable ###
                                  ### and non-removable interactions ###
print(xu.bayes$log.odds.est)   ### estimated log odds ###
print(xu.bayes$log.odds.std.err)  ### standard errors ###
print(xu.bayes$rmse)              ### root mean squared errors)


