gibbs.joint=function(data, covariates, hTheta, N.burnin, N.samples, delta, J=J)
{

subjID=data$subjID
ri=table(subjID); N=length(ri)
offset=c(1,cumsum(ri)+1)


yij=data$yij
z=data[,covariates, drop=F]
z.u=data[offset[-length(offset)],covariates]
nvars=dim(z)[2]
znam=paste("z", 1:nvars, sep="")
colnames(z)=znam
pqlinput=cbind(data, z)

n1ij=data$n1ij/10; n0ij=data$n0ij/10
nij=n1ij+n0ij
ncells=nij

####################
#generate initial values#
####################
#-------use PQL fits as initial values---------#
fmla=as.formula(paste("cbind(n1ij, n0ij)~", paste(znam, collapse= "+")))
fit=glmmPQL(fmla, random=~1|subjID, family=binomial, data=pqlinput)
b0iinit=fit$coef$random$subjID;b0iinit=as.vector(b0iinit)
b0init=as.numeric(fit$coef$fixed[1]); binit=as.vector(fit$coef$fixed[-1])
sigmabinit=as.numeric(fit$sigma)

fmla=as.formula(paste("yij~", paste(znam, collapse= "+")))
fit=glmmPQL(fmla, random=~1|subjID, family= quasi(link='log',variance='mu^2'), data=pqlinput)
#fit=glmmPQL(fmla, random=~1|subjID, family=Gamma, data=pqlinput)
a0iinit=fit$coef$random$subjID;a0iinit=as.vector(a0iinit)
a0init=as.numeric(fit$coef$fixed[1]); ainit=as.vector(fit$coef$fixed[-1])
sigmaainit=as.numeric(fit$sigma)


#--use empirical estimates as initial values---#
muijinit=yij

pijemp=n1ij/nij-0.000001 #prevent inf value from the logit function
logit=function(x){log(x/(1-x))}
b0ijinit=logit(pijemp)
#b0ijinit=(b0ijinit-mean(b0ijinit))/sd(b0ijinit)

time=data$time; event=data$event

ot=tapply(time, subjID, mean); event=tapply(event, subjID, mean)
tinterval=as.vector(quantile(ot, p=seq(0,1,length=J+1))[2:J])   

#############
#WinBUGS fit#
#############
lgtpi=log(pijemp/(1-pijemp))
if(hTheta==1){
#mean.adj=mean(lgtpi); sd.adj=sd(lgtpi);
mean.adj=4; sd.adj=0.5

temp=list(y=yij, offset=offset, z=as.matrix(z.u), nvars=nvars, N=N, n1ij=n1ij, delta=delta, ncells=ncells,
            t=as.vector(ot), recur=as.vector(event), tinterval=tinterval);
            
inits=list(beta1=0,psi=0,lambda=c(0.7,rep(0.2,J-1)), muij.inv=1/muijinit, alpha0i=a0iinit,alpha0=a0init, alpha=as.vector(rep(0,nvars)), sigmaa=sigmaainit, b0i=b0iinit,b0i.rep=b0iinit, b0ij=b0ijinit, b0=b0init, b=as.vector(rep(0,nvars)),sigmab0ij=3, sigmab=1)

            }
            

lmuij=log(muijinit)
if(hTheta==2){
mean.adj=mean(lmuij); sd.adj=sd(lmuij);
#mean.adj=0; sd.adj=0;

temp=list(y=yij,offset=offset, z=as.matrix(z.u),nvars=nvars, N=N, n1ij=n1ij, delta=delta, 
            t=as.vector(ot), recur=as.vector(event), tinterval=tinterval, mean.adj=mean.adj, sd.adj=sd.adj);
            
inits=list(beta1=0,beta=as.vector(rep(0,nvars)), lnu=log(0.01), lambda=c(0.7,rep(0.2,J-1)), muij.inv=1/muijinit, 
            alpha0i=a0iinit,alpha0=a0init,alpha=as.vector(rep(0,nvars)), sigmaa=sigmaainit)
            }
            

prods=yij*pijemp
lprods=log(prods)
if(hTheta==3){
mean.adj=mean(lprods); sd.adj=sd(lprods);
J=3; tinterval=as.vector(quantile(ot, p=seq(0,1,length=J+1))[2:J])   

temp=list(y=yij, offset=offset, z=as.matrix(z.u), nvars=nvars, N=N, n1ij=n1ij, delta=delta, ncells=ncells,
            t=as.vector(ot), recur=as.vector(event), tinterval=tinterval, mean.adj=mean.adj, sd.adj=sd.adj);
            
inits=list(beta1=0,lambda=c(0.7,rep(0.2,J-1)), muij.inv=1/muijinit, alpha0i=a0iinit,alpha0=a0init, alpha=as.vector(rep(0,nvars)), sigmaa=sigmaainit, 
            b0i=b0iinit,b0i.rep=b0iinit, b0ij=b0ijinit, b0=b0init, b=as.vector(rep(0,nvars)),sigmab0ij=3, sigmab=1)
            }

bugsData(data=temp, fileName="simudata.txt", digits=6)


inits1=inits
inits[[1]]=2; inits2=inits
inits[[1]]=-2; inits3=inits

bugsData(data=inits1, fileName="inits1.txt")

if(hTheta==1){modelCheck("jointSurvivalCMM1.txt")}
if(hTheta==2){modelCheck("jointSurvivalCMM2.txt")}
if(hTheta==3){modelCheck("jointSurvivalCMM3.txt")}
modelData("simudata.txt") 
modelCompile(numChains=1) 
modelInits(c("inits1.txt"))
modelGenInits()
modelUpdate(N.burnin) # burn in
if(hTheta%in%c(1,3)){samplesSet(c("psi","b0ij","alpha","alpha0", "alpha0i","sigmaa","muij.inv","b0i", "b0","b","sigmab0ij", "lnu", "sigmab"))}
samplesSet(c("beta1","beta"))

modelUpdate(N.samples, thin=1) 
out=samplesStats(c("beta1","beta","psi"))
beta1=out["beta1","mean"] 
beta1.sd=out["beta1","sd"] 
beta1.l=out["beta1","val2.5pc"]
beta1.u=out["beta1","val97.5pc"]

if(hTheta%in%c(1,3)){
alpha0i.hat=samplesStats("alpha0i[]")[,"mean"];

alpha0.hat=samplesStats("alpha0")[,"mean"];

alpha.hat=samplesStats("alpha[]")[,"mean"];

eta=alpha0i.hat+alpha0.hat+as.matrix(z.u)%*%t(t(alpha.hat));

muipos.h=exp(eta);


#-----contruct  pi and mui---#

b0i.history=samplesHistory("b0i", thin=1, plot=F);
b0.history=samplesHistory("b0", thin=1, plot=F);
b0.r=apply(b0.history[["b0"]], 1, mean) ;
b.history=samplesHistory("b[ ]", thin=1, plot=F);
lnu.history=samplesHistory("lnu", thin=1, plot=F);
lnu.r=apply(lnu.history[["lnu"]], 1, mean) ;
nu.r=exp(lnu.r);
b.r=NULL;
for(i in 1:nvars){;
temp=apply(b.history[[i]],1,mean) ;
b.r=cbind(b.r, temp);
};
tau2b0ij.history=samplesHistory("sigmab0ij", thin=1, plot=F);
tau2b0ij.r=apply(tau2b0ij.history[["sigmab0ij"]], 1, mean) ;

pi.h=pi.h.upper=pi.h.lower=pi.h.sd=NULL;
for(r in 1:N){;
b0i.r=apply(b0i.history[[r]], 1, mean) ;

etap=b0i.r+b0.r+b.r%*%t(as.vector(z.u[r,]));

nmcmc=length(etap);
ppij=NULL;
for(rr in 1:nmcmc){;
temp=rnorm(n=1000, mean=etap[rr], sd=sqrt(tau2b0ij.r[rr]));
ppij[rr]=mean(exp(temp)/(1+exp(temp)));
};
pi.h[r]=mean(ppij);
pi.h.sd[r]=sd(ppij);
pi.h.upper[r]=quantile(ppij, 0.975);
pi.h.lower[r]=quantile(ppij, 0.025);


};

mui.h=pi.h*muipos.h;
}

if(hTheta%in%c(1,3)){output=list(out=out,pi.h=pi.h, muipos.h=muipos.h,mui.h=mui.h, beta1=beta1,beta1.sd=beta1.sd, beta1.u=beta1.u, beta1.l=beta1.l)}
if(hTheta==2){output=list(out=out)}
output
}
