*Basic set up 
	use dca_example_dataset1.dta, clear
	g pos_test = clinical_exam=="suspicious for cancer"
	logistic cancer marker pos_test
	predict model

*Calculating a decision curve
	dca cancer model pos_test marker, prob(yes yes no) 

*Making it look nicer
	dca cancer model pos_test marker, prob(yes yes no) ///
		xstart(.05) xstop(.35) smooth  ///
		clpat(solid dash dash) clcolor(black black gray) legendoff xlabel(5(5)35)

*Saving out net benefit
	dca cancer model, xstart(0.05) xstop(0.35) xby(0.05) ///
		saving("decision curve output.dta") replace
	use "decision curve output.dta", clear
	g delta = modelp1 - all
	label var delta "Increase in net benefit from using statistical model"

*Showing net reduction in interventions
	use dca_example_dataset1.dta, clear
	keep if clinical_exam=="suspicious for cancer"
	dca cancer marker, prob(no) xstart(.05) xstop(.35) smooth legendoff xlabel(5(5)35)
	dca cancer marker, prob(no) xstart(.05) xstop(.35) ///
		smooth legendoff inter xlabel(5(5)35)

*Joint or conditional tests
	use dca_example_dataset2.dta, clear
	*clinical exam: treat high risk patients only
	g clinical_test= clinical_exam=="high risk" 
	*joint test is positive if either:
	* scan is positive or 
	* clinical exam gives high risk
	g joint=clinical_exam=="high risk" | scan==1
	*conditional test: treat if high risk; scan if intermediate risk
	g conditional=clinical_exam=="high risk" ///
		| (clinical_exam=="intermediate risk" & scan==1)
	*now run the decision curve
	dca event clinical_test joint conditional,  ///
		xstart(.1) xstop(.2) ///
		clpat(solid dash dash solid) clcolor(black black gray gray)

*Including harm	
	*the harm of a scan is stored in a local
	local harm_scan =0.0333
	*in the conditional test, only pts at intermediate risk are scanned
	g intermediate_risk= clinical_exam=="intermediate risk"
	sum intermediate_risk
	*harm of the conditional strategy is:
	*proportion scanned multiplied by harm of the scan
	local harm_conditional = r(mean)*`harm_scan'
	*now run the decision curve analysis
	dca event clinical_test joint conditional, ///
		harm(0 `harm_scan' `harm_conditional') ///
		xstart(.1) xstop(.2)  ylabel(-0.05(0.05)0.1, format(%9.2f)) ///
		clpat(solid dash dash solid) clcolor(black black gray gray)

*Evaluation of published models
	use dca_example_dataset1.dta, clear
	g logodds_Brown=1.5*(clinical_exam=="suspicious for cancer")+ ///
		0.42 * (marker/10) - 3.5
	g phat_Brown=invlogit(logodds_Brown)
	dca cancer phat_Brown, xstart(.05) xstop(.35) xlabel(5(5)35)

*Application to case control data
	use dca_example_dataset3.dta, clear
	logit cancer gene packyears
	predict xb, xb
	*The Bayes factor is: log (true odds of cancer / odds of cancer in case-control)
	local true=0.05
	sum cancer
	local design=r(mean)
	local Bayes=log((`true'/(1-`true')) / (`design'/(1-`design')))
	replace xb=xb+`Bayes'
	g phat=invlogit(xb)
	dca phat phat, xstop(.4)
	



*Application to survival data
	use dca_example_dataset4.dta, clear
	stset ttlastfollowrec, f(recurrence)
	stdca nomogram, timepoint(60)  smooth xstop(.5)
*Create predicted probabilities
	stcox age pathstage nodalstatus, basesurv(s0)
	predict xb, xb
	* the baseline survival probability to time-point 60 is stored in a local
	sum s0 if _t <= 60
	local base = r(min)
	g s60 = `base' ^ exp(xb)
	* now run decision curve
	stdca s60, timepoint(60) smooth xstop(.5)

	
	
	
*competing risk model
	g firstevent = 0
	replace firstevent = 1 if recurrence==1
	replace firstevent = 2 if recurrence==0 & dead==1
	stset ttlastfollowrec, f(firstevent=1)
	stdca nomogram, timepoint(60) cmprsk(firstevent) smooth xstop(.5)
	
	*show both competing risk and Kaplan Meier on the same graph
	* start with the standard Kaplan Meier model, saving the results to a temporary file
	stset ttlastfollowrec, f(recurrence)
	tempfile km
	stdca nomogram, timepoint(60) saving(`km') graphoff smooth  xstop(.5)
	* now do the competing risk model, again saving the results to a temporary file
	stset ttlastfollowrec, f(firstevent=1)
	tempfile cr
	stdca nomogram, timepoint(60) cmprsk(firstevent) ///
		saving(`cr') graphoff smooth xstop(.5)
	*now merge the results
	*start with the Kaplan Meier estimates
	use `km', clear
	*sort so that it can be merged later
	sort threshold
	*rename the variables so that we know it is the Kaplan-Meier model
	rename modelp1 kmmodel
	rename all kmall
	tempfile kmsort
	save `kmsort'
	*now repeat for competing risk model
	use `cr', clear
	sort threshold
	*do the actual merge
	merge threshold using `kmsort'
	rename modelp1 crmodel
	rename all crall
	*now create the graph 
	twoway(line kmall kmmodel crall crmodel none threshold, sort ///
		clpat(solid solid dash dash solid)  ///
		clwidth(medthick medium medthick medium medthick) ///
      		clcolor(gs10 gs0 gs10 gs0 gs0)), ///
		scheme(s1mono) xtitle(Threshold probability in %, margin(medium)) ///
		ytitle(Net Benefit, margin(medium)) ///
		ylabel(, format(%9.2f)) legend(off)


